data {
    int N;
    array[N] vector[2] Data;
}
parameters {
    real mu1;
    real mu2;
    real<lower = 0.0001, upper=1000> sgm1;
    real<lower = 0.0001, upper=1000> sgm2;
    real<lower = -0.9999, upper = 0.9999> rho;
}
transformed parameters {
    real d; 
    vector[2] mus;
    cov_matrix[2] cov;
    d = mu2 - mu1;
    mus[1] = mu1;
    mus[2] = mu2;
    cov[1][1] = sgm1*sgm1;
    cov[1][2] = rho*sgm1*sgm2;
    cov[2][1] = rho*sgm2*sgm1;
    cov[2][2] = sgm2*sgm2;
}
model {
    mu1 ~ normal(0.0, 1000.0);
    mu2 ~ normal(0.0, 1000.0);
    sgm1 ~ uniform(0.0001, 1000);  
    sgm2 ~ uniform(0.0001, 1000);  
    rho ~ uniform(-0.9999, 0.9999);
    for (i in 1:N)
        Data[i] ~ multi_normal(mus, cov);
}

