import scipy.stats as ss
import numpy as np
import matplotlib.pyplot as plt
from cmdstanpy import CmdStanModel
import seaborn as sb
import arviz as az

data = [
        [73, 70], [68, 61], [71, 68], [68, 62], [61, 60],
        [73, 70], [80, 81], [71, 72], [75, 65], [59, 52],
        [89, 85], [68, 71], [96, 91], [88, 83], [79, 78],
        [68, 69], [71, 65], [66, 64], [72, 69], [78, 72]
        ]

plt.scatter(np.array(data)[:,0], np.array(data)[:,1])
plt.xlabel('X')
plt.ylabel('Y')
plt.title('Scattergram of (X,Y)', fontsize=16)
plt.tight_layout()
plt.savefig('FigScatter.png')
plt.show()
saved_files = ['FigScatter.png']

DataStan = {'N': len(data), 'Data': data}

model = CmdStanModel(stan_file='DiffMeans.stan')
fit = model.sample(data=DataStan)

print(fit.summary())

infdata = az.from_cmdstanpy(fit)         # Arviz InfereceData型へ変換
az.plot_trace(infdata, figsize=(12,8))  
plt.tight_layout()
plt.savefig('FigTrace.png')
plt.show()
saved_files.append('FigTrace.png')

fit = fit.draws_pd()                     #  Pndas DataFrame型への変換

plt.figure(figsize=(12, 8))

plt.subplot(221)
p025, med, p975 = np.percentile(fit['d'], [2.5, 50, 97.5])
pposd = np.mean(fit['d']>0)
sb.kdeplot(fit['d'])
plt.title(fr'$\mu2-\mu1:$  95%CI=[{p025:.2f}, {p975:.2f}]' + '\n' +
          fr'$P(\mu2>\mu1)=${pposd:.2f},   Med.={med:.2f}', fontsize=14)
plt.yticks([])
plt.xlabel(r'$\mu2-\mu1$', fontsize=14)

plt.subplot(222)
sb.kdeplot(fit['mu1'], label = 'μ1')
sb.kdeplot(fit['mu2'], label = 'μ2')
plt.title('Posterior Distributions', fontsize=16)
plt.yticks([])
plt.xlabel('')
plt.legend(fontsize = 12)

plt.subplot(223)
sb.kdeplot(fit['sgm1'], label = 'σ1')
sb.kdeplot(fit['sgm2'], label = 'σ2')
plt.title('Posterior Distributions', fontsize=16)
plt.xlabel('')
plt.yticks([])
plt.legend(fontsize = 12)

plt.subplot(224)
sb.kdeplot(fit['rho'])
plt.title('Posterior Distribution of ρ', fontsize = 18)
plt.yticks([])
plt.xlabel(r'$\rho$', fontsize=14)
plt.tight_layout()
plt.savefig('Figs.png')
plt.show()
saved_files.append('Figs.png')

xy_smpls = []
for mu1, mu2, sgm1, sgm2, r in zip(fit['mu1'], fit['mu2'],
                                   fit['sgm1'], fit['sgm2'],fit['rho']):
    mean = [mu1, mu2]
    cov = [[sgm1**2, r*sgm1*sgm2], [r*sgm2*sgm1, sgm2**2]]
    xy = ss.multivariate_normal.rvs(mean, cov)
    plt.plot(xy[0], xy[1], 'o', lw=0)
    xy_smpls.append(xy)
xy_smpls = np.array(xy_smpls)
ppos_xy = np.mean(xy_smpls[:,1] > xy_smpls[:,0])
xy_min = np.min(xy_smpls)
xy_max = np.max(xy_smpls)
plt.plot([xy_min, xy_max], [xy_min, xy_max], c='r', lw=2, label='Y=X')
plt.title('Predictive Distribution of (X, Y)' + '\n' +
          f'P(Y>X)={ppos_xy:.5f}', fontsize=16)
plt.xlabel('X', fontsize=14)
plt.ylabel('Y', fontsize=14)
plt.legend(fontsize=14)
plt.tight_layout()
plt.savefig('FigPredXY.png')
plt.show()
saved_files.append('FigPredXY.png')

print('\nSaved files...')
for nm in saved_files:
    print(nm)
