import numpy as np
import scipy.stats as ss
import matplotlib.pyplot as plt
import seaborn as sb
from cmdstanpy import CmdStanModel
import arviz as az
import pandas as pd

inflnm = input('Input data file (*.xlsx) = ')
data_pd = pd.read_excel(inflnm).values
print(data_pd)
n_n = data_pd[:,1]
n_s = data_pd[:,2]
s_n = data_pd[:,3]
s_s = data_pd[:,4]

print('n_n =', n_n)
print('n_s =', n_s)
print('s_n =', s_n)
print('s_s =', s_s)

K = len(n_n)
if K < 3:
    print('Number of categories should be larger than 2.')
    sys.exit()
if len(n_s) != K:
    print('Numbers of categories are not consistent.')
    sys.exit()
if len(s_n) != K:
    print('Numbers of categories are not consistent.')
    sys.exit()
if len(s_s) != K:
    print('Numbers of categories are not consistent.')
    sys.exit()

Data = {'K':K, 'nn_cond':n_n, 'ns_cond':n_s, 'sn_cond':s_n, 'ss_cond':s_s}
stan_code = 'SDT_2AFC_KCat_odd.stan' if K % 2 == 1 else \
            'SDT_2AFC_KCat_even.stan'
model = CmdStanModel(stan_file=stan_code)
fit = model.sample(data=Data)  

print(fit.diagnose())
print(fit.summary())

infdata = az.from_cmdstanpy(fit)  # Arviz InfereceData型へ変換
az.plot_trace(infdata, var_names=['mu_s', 'sgm_s'])  
plt.tight_layout()
plt.savefig('Fig_trace.png')
plt.show()

fit = fit.draws_pd()              #  Pandas DataFrame型への変換
print(fit.keys())

mu_s_med = np.median(fit['mu_s']) 
sb.kdeplot(fit['mu_s'])
plt.xlabel(r'$\mu_s$')
plt.title(r'$\mu_s$(Med) = {0:.3f}'.format(mu_s_med))
plt.savefig('Fig_mu.png')
plt.show()

sgm_s_med = np.median(fit['sgm_s'])
p_sgmL1 = np.mean(fit['sgm_s'] > 1.0)
sb.kdeplot(fit['sgm_s'])
plt.title(r'$\sigma_s$(Med) = {0:.3f},   P($\sigma_s$>1) = {1:.5f}'.format
          (sgm_s_med, p_sgmL1))
plt.xlabel(r'$\sigma_s$')
plt.savefig('Fig_sgm.png')
plt.show()

Csmpls = []
for k in range(K-1):
    Csmpls.append(fit[f'C[{k+1}]'])
Csmpls = np.array(Csmpls).T
print('Shape_Csmpls =', np.shape(Csmpls))

s_title = ''
if K % 2 == 1:
    for k in range(K-1):
        sb.kdeplot(Csmpls.T[k])  
        c_med = np.median(Csmpls.T[k]) 
        s_title += f'C{k+1}={c_med:.2f}'
        if k < K-2:
            s_title += ', '
else:
    for k in range(K-1):
        if k != (K//2) - 1:
            sb.kdeplot(Csmpls.T[k])   
            c_med = np.median(Csmpls.T[k])  
            s_title += f'C{k+1}={c_med:.2f}'
            if k < K-2:
                s_title += ', '
        else:
            plt.plot([0], [0], marker = 'o', markersize = 15, c = 'r')
            s_title += f'C{k+1}=0, '
            
plt.title('Median estimates\n' + s_title)
plt.savefig('FigC.png')
plt.show()

b_med = np.median(fit['b'])  
sb.kdeplot(fit['b'])
plt.title('b(Med) = {0:.3f}'.format(b_med))
plt.savefig('Fig_b.png')
plt.show()

cum_n_n = np.cumsum(n_n)
pcum_n_n = cum_n_n/cum_n_n[-1]
cum_n_s = np.cumsum(n_s)
pcum_n_s = cum_n_s / cum_n_s[-1]
cum_s_n = np.cumsum(s_n)
pcum_s_n = cum_s_n / cum_s_n[-1]
cum_s_s = np.cumsum(s_s)
pcum_s_s = cum_s_s / cum_s_s[-1]

nn_cum_p_smpls = []
ns_cum_p_smpls = []
sn_cum_p_smpls = []
ss_cum_p_smpls = []
for k in range(K+1):
    nn_cum_p_smpls.append(fit[f'nn_cum_p[{k+1}]'])
    ns_cum_p_smpls.append(fit[f'ns_cum_p[{k+1}]'])
    sn_cum_p_smpls.append(fit[f'sn_cum_p[{k+1}]'])
    ss_cum_p_smpls.append(fit[f'ss_cum_p[{k+1}]'])
nn_cum_p_smpls = np.array(nn_cum_p_smpls).T
ns_cum_p_smpls = np.array(ns_cum_p_smpls).T
sn_cum_p_smpls = np.array(sn_cum_p_smpls).T
ss_cum_p_smpls = np.array(ss_cum_p_smpls).T
    

est_pcum_n_n = np.median(nn_cum_p_smpls, axis=0)[1:-1]
est_pcum_n_s = np.median(ns_cum_p_smpls, axis=0)[1:-1]
est_pcum_s_n = np.median(sn_cum_p_smpls, axis=0)[1:-1]
est_pcum_s_s = np.median(ss_cum_p_smpls, axis=0)[1:-1]

plt.plot(est_pcum_n_n, pcum_n_n[:-1], label = 'n_n')
plt.plot(est_pcum_n_s, pcum_n_s[:-1], label = 'n_s')
plt.plot(est_pcum_s_n, pcum_s_n[:-1], label = 's_n')
plt.plot(est_pcum_s_s, pcum_s_s[:-1], label = 's_s')
plt.plot([0,1], [0,1], c = 'k', ls = '--', label = 'Obs.=Est.')
plt.xlabel('Est.Cum.P')
plt.ylabel('Obs.Cum.P')
plt.legend()
plt.title('Cumulative Proportions')
plt.savefig('FigCumEstObs.png')
plt.show()
