data {
    int K;
    array[K] int nn_cond;
    array[K] int ns_cond;
    array[K] int sn_cond;
    array[K] int ss_cond;
}
transformed data {
    int hK;
    vector[K%/%2] alpha;
    hK = K %/% 2;
    for (i in 1:hK) {
        alpha[i] = 1.0;
    }
}
parameters {
    real mu_s;
    real<lower = 0.00001> sgm_s;
    real b;
    simplex[hK] preC;
}
transformed parameters {
    vector[K] nn_theta;
    vector[K] ns_theta;
    vector[K] sn_theta;
    vector[K] ss_theta;
    vector[K+1] nn_cum_p;
    vector[K+1] ns_cum_p;
    vector[K+1] sn_cum_p;
    vector[K+1] ss_cum_p;
    vector[K-1] C;
    real vsum;
    real sgm_nn;
    real sgm_ns;
    real sgm_ss;

    C[hK] = 0.0;
    vsum = 0.00005;
    for (i in 1:hK-1) {
        vsum += 0.9999*preC[i];
        C[hK+i] = vsum / (1.0 - vsum);
        C[hK-i] = -C[hK+i];
    }

    sgm_nn = sqrt(1.0 + 1.0);
    sgm_ns = sqrt(1.0 + square(sgm_s));
    sgm_ss = sqrt(square(sgm_s)*2);

    nn_cum_p[1] = 0.0;
    ns_cum_p[1] = 0.0;
    sn_cum_p[1] = 0.0;
    ss_cum_p[1] = 0.0;
    nn_cum_p[K+1] = 1.0;
    ns_cum_p[K+1] = 1.0;
    sn_cum_p[K+1] = 1.0;
    ss_cum_p[K+1] = 1.0;
    
    for (i in 2:K) {
        nn_cum_p[i] = 0.00005 + 0.9999*normal_cdf(C[i-1] | b, sgm_nn);
        ns_cum_p[i] = 0.00005 + 0.9999*normal_cdf(C[i-1] | mu_s + b, sgm_ns);
        sn_cum_p[i] = 0.00005 + 0.9999*normal_cdf(C[i-1] | -mu_s + b, sgm_ns);
        ss_cum_p[i] = 0.00005 + 0.9999*normal_cdf(C[i-1] | b, sgm_ss);
    }

    for (i in 1:K) {
        nn_theta[i] = nn_cum_p[i+1] - nn_cum_p[i];
        ns_theta[i] = ns_cum_p[i+1] - ns_cum_p[i];
        sn_theta[i] = sn_cum_p[i+1] - sn_cum_p[i];
        ss_theta[i] = ss_cum_p[i+1] - ss_cum_p[i];
    }
}
model {
    mu_s ~ normal(0.0, 1000.0);
    sgm_s ~ uniform(0.00001, 1000.0); 
    preC ~ dirichlet(alpha);
    b ~ normal(0.0, 1000.0);
    nn_cond ~ multinomial(nn_theta);
    ns_cond ~ multinomial(ns_theta);
    sn_cond ~ multinomial(sn_theta);
    ss_cond ~ multinomial(ss_theta);
}
