data {
    int<lower = 3> K;
    array[K] int<lower = 0> Freq_Noise;
    array[K] int<lower = 0> Freq_Signal;
}
parameters {
    real mu;
    real<lower = 0.0, upper = 5.0> sigma;
    ordered[K-1] c;
}
transformed parameters {
    vector[K] theta_n;
    vector[K] theta_s;

    theta_n[1] = normal_cdf(c[1] | 0.0, 1.0);  
    theta_n[K] = 1.0 - normal_cdf(c[K-1] | 0.0, 1.0); 
    for (k in 2:(K-1))
        theta_n[k] = normal_cdf(c[k] | 0.0, 1.0) - normal_cdf(c[k-1] | 0.0, 1.0);   
    theta_s[1] = normal_cdf((c[1] - mu) / sigma | 0.0, 1.0);
    theta_s[K] = 1.0 - normal_cdf((c[K-1] - mu) / sigma | 0.0, 1.0);   
    for (k in 2:(K-1))
        theta_s[k] =normal_cdf((c[k] - mu) / sigma | 0.0, 1.0) -
                      normal_cdf((c[k-1] - mu) / sigma | 0.0, 1.0);}
model {
    mu ~ normal(0.0, 10.0);
    sigma ~ uniform(0, 5);
    Freq_Noise ~ multinomial(theta_n);
    Freq_Signal ~ multinomial(theta_s);
}
