data {
    int NSt;
    int K;
    array[NSt] real Sts;
    array[NSt, K] int Rs;
}
transformed data {
    vector[K-2] a_C;
    for (i in 1:(K-2)) {
        a_C[i] = 1.0;
    }
}
parameters {
    //simplex[NSt+1] prePsis;
    array[NSt] real Psis;
    simplex[K-2] preC;
    real<lower = 0.0001> sgm;
}
transformed parameters {
    array[K-1] real C;
    array[NSt] simplex[K] theta;
    
    C[1] = 0.0;
    C[K-1] = 1.0;
    for (k in 2:(K-2)) {
        C[k] = C[k-1] + preC[k-1];
    }
    for (s in 1:NSt) {
        theta[s][1] = normal_cdf(C[1] | Psis[s], sgm);
        theta[s][K] = 1.0 - normal_cdf(C[K-1] | Psis[s], sgm);
        for (k in 2:(K-1)) {
            theta[s][k] = normal_cdf(C[k] | Psis[s], sgm) -
                            normal_cdf(C[k-1] | Psis[s], sgm);
        }
    }
}
model {
    preC ~ dirichlet(a_C);
    sgm ~ uniform(0.0001, 1000);  
    for (s in 1:NSt) {
        Psis[s] ~ normal(0.0, 10.0);
        Rs[s] ~ multinomial(theta[s]);
    }
}
