data {
    int NSt;
    int K;
    array[NSt] real Sts;
    array[NSt, K] int Rs;
}
transformed data {
    vector[NSt+1] a_Psis;
    vector[K-2] a_C;
    
    for (i in 1:(NSt+1)) {
        a_Psis[i] = 1.0;
    }
    for (i in 1:(K-2)) {
        a_C[i] = 1.0;
    }
}
parameters {
    array[NSt] real<lower = 0.0> vsgms;
    simplex[NSt+1] prePsis;
    simplex[K-2] preC;
}
transformed parameters {
    array[NSt] real<lower = 0.0> sgms;
    array[NSt] real Psis;
    array[K-1] real C;
    array[NSt] simplex[K] theta;
    real v;

    for (s in 1:NSt) {
        sgms[s] = vsgms[s] + 0.0001;
    }
    v = 0.0005;
    for (s in 1:NSt) {
        v = v + prePsis[s]*0.999;
        Psis[s] = logit(v);
    }
    
    C[1] = 0.0;
    C[K-1] = 1.0;
    v = 0.0;
    for (k in 2:(K-2)) {
        v = v + preC[k-1];
        C[k] = C[1] + v;
    }
    for (s in 1:NSt) {
        theta[s][1] = normal_cdf(C[1] | Psis[s], sgms[s]);
        theta[s][K] = 1.0 - normal_cdf(C[K-1] | Psis[s], sgms[s]);
        for (k in 2:(K-1)) {
            theta[s][k] = normal_cdf(C[k] | Psis[s], sgms[s]) -
                            normal_cdf(C[k-1] | Psis[s], sgms[s]);
        }
    }
}
model {
    for (s in 1:NSt) {
        vsgms[s] ~ exponential(0.001);
    }
    prePsis ~ dirichlet(a_Psis);
    preC ~ dirichlet(a_C);
    for (s in 1:NSt) {
        Rs[s] ~ multinomial(theta[s]);
    }
}
