from cmdstanpy import CmdStanModel
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sb

foutnm = input("Output file (*.txt) = ") 
fout = open(foutnm, 'w')   
#
#       Excelデータファイルの読み込み
#
s = input("Input Excel data file (*.xlsx) = ")
xlsx_fl = pd.ExcelFile(s)
data_xlsx = pd.read_excel(xlsx_fl)

var_names = [v for v in data_xlsx.keys()][1:]
print('var_names =', var_names)

data = data_xlsx.values
print('data...\n', data)
fout.write(f'Input data file = {s}\n')
fout.write(f'\ndata...\n{data}\n')
X = data[:,1:]

mus = np.mean(X, axis=0)
stds = np.std(X, axis=0)

Data = {'N': len(X), 'M': len(X[0]), 'X': X, 'i_mu': mus, 'i_std': stds}

model = CmdStanModel(stan_file="est_omega.stan")    #   コンパイル
fit = model.sample(data=Data)                       #   サンプリング

print(fit.summary())
fout.write('\n{}'.format(fit.summary()))

df = fit.draws_pd()           

print()
fout.write('\n\nMu...\n')
for j in range(len(X[0])):
    q1, med, q3 = np.percentile(df[f'mu[{j+1}]'], [25, 50, 75])
    print(f'Mu[{j+1}]:', end = '')
    print(f'  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}')
    fout.write(f'Mu[{j+1}]:  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}\n')

mus = np.mean(X, axis=0)
stds = np.std(X, axis=0)

#
#        muの事後分布
#
for j in range(len(X[0])):
    sb.kdeplot(df[f'mu[{j+1}]'], label=f'{var_names[j]}')
plt.title(r'$\mu$', fontsize = 16)
plt.xlabel('')
plt.legend(bbox_to_anchor=(1.0, 1.0))
plt.tight_layout()
plt.show()
#
#        Sigmaの4分位数の計算
#
print()
fout.write('\nSigma...\n')
for j in range(len(X[0])):
    q1, med, q3 = np.percentile(df[f'sgm[{j+1}]'], [25, 50, 75])
    print(fr'Sigma[{j+1}]:', end = '')
    print(f'  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}')
    fout.write(f'Sigma[{j+1}]:  Q1 = {q1:.3f}' +
               f'  Med = {med:.3f},  Q3 = {q3:.3f}\n')
#
#        Sigmaの事後分布
#
for j in range(len(X[0])):
    sb.kdeplot(df[f'sgm[{j+1}]'], label=f'{var_names[j]}')
plt.title(r'$\sigma$', fontsize = 16)
plt.xlabel('')
plt.legend(bbox_to_anchor=(1.0, 1.0))
plt.tight_layout()
plt.show()
#
#       Lambdaの四分位数の計算
#
print()
fout.write('\nLambda...\n')
for j in range(len(X[0])):
    q1, med, q3 = np.percentile(df[f'Lmbd[{j+1}]'], [25, 50, 75])
    print(fr'Lambda[{j+1}]:', end = '')
    print(f'  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}', end = '')
    print(f'  ({var_names[j]})')
    fout.write(f'Lambda[{j+1}]:  Q1 = {q1:.3f}' +
               f'  Med = {med:.3f},  Q3 = {q3:.3f}' +
               f'  ({var_names[j]})\n')
#
#       Lambdaの事後分布
#
for j in range(len(X[0])):
    sb.kdeplot(df[f'Lmbd[{j+1}]'], label=f'{var_names[j]}')
plt.title(r'$\lambda$', fontsize = 16)
plt.xlabel('')
plt.legend(bbox_to_anchor=(1.0, 1.0))
plt.tight_layout()
plt.savefig('FigLmbd.png')
plt.show()
#
#           真値の割合の計算
#
print()
fout.write('\nLambda_j**/Var(X_j)...\n')
for j in range(len(X[0])):
    q1, med, q3 = np.percentile(df[f'L2V[{j+1}]'], [25, 50, 75])
    print(f'Lambda[{j+1}]**2 / Var(X[{j+1}]):', end = '')
    print(f'  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}')
    fout.write(f'Lambda[{j+1}]**2 / Var(X[{j+1}]):' +
               f'  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}\n')

for j in range(len(X[0])):
    sb.kdeplot(df[f'L2V[{j+1}]'], label=f'{var_names[j]}')
plt.title(r'$\lambda^{2}_{j}/Var(X_{j})$', fontsize = 16)
plt.xlabel('')
plt.legend(bbox_to_anchor=(1.0, 1.0))
plt.tight_layout()
plt.show()
#
#            Omegaの四分位数の計算
#
print()
q1, med, q3 = np.percentile(df[f'omg'], [25, 50, 75])
print(f'omega:  Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}')
fout.write('\nomega...\n')
fout.write(f'         Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}\n')
#
#           Omegaの事後分布
#
sb.kdeplot(df['omg'])
plt.title(f'Q1 = {q1:.3f},  Med = {med:.3f},  Q3 = {q3:.3f}', fontsize = 14)
plt.xlabel(r'$\omega$', fontsize = 16)
plt.tight_layout()
plt.show()
#
#       （因子得点F、尺度得点和）の散布図
#
sumXs = np.sum(X, axis = 1)
Fs = []
for i in range(len(X)):
    Fs.append(np.median(df[f'F[{i+1}]']))
plt.plot(Fs, sumXs, 'o')
plt.xlabel(r'$\widehat{F}_{median}$', fontsize = 14)
plt.ylabel(r'$\sum{X_{j}}$', fontsize = 14)
plt.tight_layout()
plt.show()
              
fout.close()
print(foutnm, 'was saved.\n')


