//
//          Yasuharu Okamoto, 2023.08, 2025.03
//
data {
    int N;
    int M;
    array[N,M] real X;
    vector[M] i_mu;
    vector[M] i_std;
}
parameters {
    vector[N] vF;
    vector[M] v_mu;
    vector<lower=0.0>[M] v_Lmbd;
    vector<lower=0.0>[M] v_sgm;
}
transformed parameters {
    vector[N] F;
    real sumF;
    real ssF;
    real meanF;
    real sdF;
    vector[M] mu;
    vector[M] Lmbd;
    vector[M] sgm;
    array[N] vector[M] V;
    //
    //        Standardized F values
    //
    sumF = 0.0;
    ssF = 0.0;
    for (i in 1:N) {
        sumF += vF[i];
        ssF += pow(vF[i], 2);
    }
    meanF = sumF / N;
    sdF = pow((ssF - N * pow(meanF, 2)) / (N - 1), 0.5);
    F = (vF - meanF) / sdF;       //  標準化
    //
    //          Rescaled parameters
    //
    mu = i_mu + 10.0 .* i_std .* v_mu;
    Lmbd = 10.0 .* i_std .* v_Lmbd;
    sgm = 0.001 + 10.0 .* i_std .* v_sgm;
    //
    //          Regression model
    //
    for (i in 1:N)
        V[i] = mu + Lmbd * F[i];
}
model {
    vF ~ normal(0.0, 1.0);
    v_mu ~ normal(0.0, 10.0);
    v_Lmbd ~ exponential(0.1);
    v_sgm ~ exponential(0.1);
    for (i in 1:N)
        X[i] ~ normal(V[i], sgm);
}
generated quantities {
    real omg;               //  omega
    vector[M] L2V;
    real v1;
    real v2;
    v1 = 0.0;
    v2 = 0.0;
    L2V = pow(Lmbd, 2.0) ./ (pow(Lmbd, 2.0) + pow(sgm, 2.0));
    for (j in 1:M) {
        v1 += Lmbd[j];
        v2 += pow(sgm[j], 2);
    }
    omg = pow(v1, 2) / (pow(v1, 2) + v2);
}
