
data {
    array[2] int<lower = 0> Freq_Noise;       //  [Correct Rejection, False Alarm]
    array[2] int<lower = 0> Freq_Signal;      //  [Miss, Hit]
}

parameters {
    real mu;
    real<lower = 0> c;
}

transformed parameters {
    real pyes_n;
    real pyes_s;
    pyes_n = 1.0 - normal_cdf(c | 0.0, 1.0);    //      Probability of FA
    pyes_s = 1.0 - normal_cdf(c | mu, 1.0);     //      Probability of Hit
}

model {
    Freq_Noise[2] ~ binomial(Freq_Noise[1] + Freq_Noise[2], pyes_n);
    Freq_Signal[2] ~ binomial(Freq_Signal[1] + Freq_Signal[2], pyes_s);
}
