from cmdstanpy import CmdStanModel
import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import scipy.stats as ss
import seaborn as sb
import arviz as az


outfnm = input('Outut file (*.txt) = ')
fout = open(outfnm, 'w')

inflnm = input('Input DataFile (*.xlsx) = ')
df_data = pd.read_excel(inflnm)
print(df_data)

Data_Noise = df_data.values[0,1:]
print(Data_Noise)

Data_Signal = df_data.values[1,1:]
print(Data_Signal)

fout.write('Data for Noise:  {}\n'.format(Data_Noise))
fout.write('Data for Signal: {}\n'.format(Data_Signal))

Data = {'Freq_Noise': Data_Noise, 'Freq_Signal': Data_Signal}

model = CmdStanModel(stan_file="YN_EqSgm.stan")    #   コンパイル
fit = model.sample(data=Data)                      #   サンプリング

print(fit.summary())
fout.write('\n{}'.format(fit.summary()))

inf_data = az.from_cmdstanpy(fit)           #   Arviz(az)用のデータに変換
az.plot_trace(inf_data, figsize=(10,7))     #   トレースプロット
plt.tight_layout()
plt.show()

fit = fit.draws_pd()                        #   Pandas DataFrameへ変換

mu = fit['mu']
c = fit['c']

mu_mean = mu.mean()
mu_q025, mu_med, mu_q975 = np.percentile(mu, [2.5, 50, 97.5])

fout.write('\n\nmu:\n')
fout.write('median   = {0:.3f}\n'.format(mu_med))
fout.write('mean     = {0:.3f}\n'.format(mu_mean))
fout.write('95% CI   = [{0:.3f}, {1:.3f}]\n'.format(mu_q025, mu_q975))
           
sb.kdeplot(mu)
plt.title(fr"$\mu$(d') = {mu_med:.3f}(med)," +
          f"   95% CI = [{mu_q025:.3f}, {mu_q975:.3f}]", fontsize=16)
plt.yticks([])
plt.xlabel(r'$\mu$', fontsize = 16)
plt.tight_layout()
plt.show()

c_mean = c.mean()
c_q025, c_med, c_q975 = np.percentile(c, [2.5, 50, 97.5])

fout.write('\n\nC:\n')
fout.write('median   = {0:.3f}\n'.format(c_med))
fout.write('mean     = {0:.3f}\n'.format(c_mean))
fout.write('95% CI   = [{0:.3f}, {1:.3f}]\n'.format(c_q025, c_q975))
         
sb.kdeplot(c)
plt.xlabel('C', fontsize = 16)
plt.title(f"Criterion = {c_med:.3f}(med)," +
          f"  95% CI = [{c_q025:.3f}, {c_q975:.3f}]", fontsize=16)
plt.show()

plt.figure(figsize=(9,5))
x_min = -3
x_max = 3 + mu_med
xcoord = np.arange(x_min, x_max, 0.01)
y_noise = ss.norm.pdf(xcoord, 0.0, 1.0)
plt.plot(xcoord, y_noise, lw=3, c='orange', label='noise')
y_signal = ss.norm.pdf(xcoord, mu_med, 1.0)
plt.plot(xcoord, y_signal, lw=3, c='g', label='signal')
plt.plot([c_med, c_med], [0.0, 0.4], c='r', label='Criterion')
plt.plot([x_min, x_max], [0, 0], c='k', lw=2)
plt.title(f"C = {c_med:.3f},  mu(d') = {mu_med:.3f}", fontsize=18)
plt.legend(fontsize=14)
plt.tight_layout()
plt.show()

fout.close()
print('\n', outfnm, 'was saved.\n')
