#
#           Yasuharu Okamoto, 2019.10, 2025.10
#
from cmdstanpy import CmdStanModel
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sb
import csv
import pickle

flnm = input('入力データファイル名(*.csv) = ')
with open(flnm, 'r') as f:
    data = [v for v in csv.reader(f)]

fout_nm = input('出力テキストファイル名 = ')
fout = open(fout_nm, 'w')
fout.write('Input Data File = {}\n'.format(flnm))

K = len(data[0]) - 1
print('K = ', K)
if (K % 2) == 1:
    print('評定カテゴリ数は偶数でなければならない!')
    import sys
    sys.exit()
    
Freq_NS = []
for k in range(K):
    Freq_NS.append(int(data[1][1 + k]))
Freq_SN = []
for k in range(K):
    Freq_SN.append(int(data[2][1 + k]))
print(Freq_NS)
print(Freq_SN)
fout.write('\n<N, S>\n{}\n'.format(Freq_NS))
fout.write('\n<S, N>\n{}\n'.format(Freq_SN))   
TN_NS = sum(Freq_NS)
Rating_NS = Freq_NS
print(Rating_NS)
TN_SN = sum(Freq_SN)
Rating_SN = []
for k in range(K):
    Rating_SN.append(Freq_SN[K - 1 - k])

Data = {'K': K, 'n_NS': Rating_NS, 'n_SN': Rating_SN}

model = CmdStanModel(stan_file='SDT2AFCEvenCat.stan')
fit = model.sample(data=Data)   

print(fit.summary())
fout.write(f'\n{fit.summary()}\n')


fit = fit.draws_pd()


mu = fit['mu_s']
tau = fit['tau']
C = []
for k in range(K-1):
    C.append(fit[f'C[{k+1}]'])
C = np.array(C).T

p_NS = []
p_SN = []
for k in range(K):
    p_NS.append(fit[f'p_NS[{k+1}]'])
    p_SN.append(fit[f'p_SN[{k+1}]'])
p_NS = np.array(p_NS).T
p_SN = np.array(p_SN).T

mu_L05 = np.percentile(mu, 5)
mu_med = np.percentile(mu, 50)
mu_U95 = np.percentile(mu, 95)
fout.write("\nd':\nMedian = {0:<.3f},   90%CI = [{1:<.3f}, {2:<.3f}]\n".
           format(mu_med, mu_L05, mu_U95))

tau_L05 = np.percentile(tau, 5)
tau_med = np.percentile(tau, 50)
tau_U95 = np.percentile(tau, 95)
fout.write('\ntau:\nMedian = {0:<.3f},   90%CI = [{1:<.3f}, {2:<.3f}]\n'.
           format(tau_med, tau_L05, tau_U95))

C_L05 = np.zeros(K-1)
C_med = np.zeros(K-1)
C_U95 = np.zeros(K-1)
for k in range(K-1):
    C_L05[k] = np.percentile(C.T[k], 5)
    C_med[k] = np.percentile(C.T[k], 50)
    C_U95[k] = np.percentile(C.T[k], 95)
for k in range(K-1):
    fout.write(('\nC[{0}]:\n' + \
               'Median = {1:<.3f},   90%CI = [{2:<.3f}, {3:<.3f}]\n').
               format(k+1, C_med[k], C_L05[k], C_U95[k]))

sb.kdeplot(mu)
plt.xlabel(r"d'($\mu_S$)", fontsize = 14)
plt.title(r"Posterior Distribution of d'($\mu_S$)" + \
          '\nMed. = {0:<.3f},   90%CI = [{1:<.3f}, {2:<.3f}]'.
          format(mu_med, mu_L05, mu_U95), fontsize = 16)
plt.show()

sb.kdeplot(tau)
plt.xlabel(r'$\tau$', fontsize = 18)
plt.title(r'Posterior Distribution of $\tau$' + \
          '\nMed. = {0:<.3f},   90%CI = [{1:<.3f}, {2:<.3f}]'.
          format(tau_med, tau_L05, tau_U95), fontsize = 16)
plt.show()

for k in range(K-1):
    if k + 1 != K/2:
        sb.kdeplot(C.T[k], label = 'C{}'.format(k+1))
plt.title('Posterior Distributions of Category Boundaries' + \
          '\nC{} = 0 fixed'.format(K//2), fontsize = 16)
plt.legend(loc = 'lower center')
plt.show()

xcat = np.arange(1, K+0.1, 1)
xlabels = ['{}'.format(int(v)) for v in xcat]
y1 = []
y2 = []
for k in range(K):
    y1.append(Freq_NS[k]/TN_NS)
    y2.append(Freq_SN[k]/TN_SN)

p1 = np.median(p_NS, axis = 0)
p2 = np.median(p_SN, axis = 0)
p2 = np.flip(p2)

plt.plot(xcat, y1, c='b', marker='s', markersize=20,
         linewidth = 0, label = 'Data/<N, S>')
plt.plot(xcat, p1, c='g', marker='o', markersize=30, fillstyle='none',
         linewidth = 0, markeredgewidth=3, label = 'Model/<N, S>')
plt.plot(xcat, y2, c='r', marker='s', markersize=20,
         linewidth = 0, label = 'Data/<S, N>')
plt.plot(xcat, p2, c='m', marker='o', markersize=30, fillstyle='none',
         linewidth = 0, markeredgewidth=3, label = 'Model/<S, N>')

plt.xticks(xcat, xlabels, fontsize = 14)
plt.xlabel('Rating Category', fontsize = 14)
plt.ylabel('Probability/Proportion', fontsize = 14)
plt.yticks(np.arange(0, 1.01, 0.2))
plt.title('Ratings in Conditions <N, S> and <S, N>', fontsize = 18)
plt.legend(loc = 'upper center', fontsize = 18)
plt.show()

fout.close()
print('\n{} was saved.\n'.format(fout_nm))
