//
//      Number of Rating categoriees should be even
//
//              Yasuharu Okamoto, 2019.10, 2025.10
//
functions {
    real half_normal_lpdf(real y, real sgm){
        if (y > 0.0){
            return normal_lpdf(y | 0.0, sgm);
        } else {
            return log(0.0);
        }
    }
}
data {
    int K;
    array[K] int n_NS;
    array[K] int n_SN;
}

parameters {
    real mu_s;
    real tau;
    array[K/2 - 1] real<lower = 0.0> theta;
}
transformed parameters {
    array[K-1] real C;
    simplex[K] p_NS;
    simplex[K] p_SN;
    C[K/2] = 0.0;
    for (k in 1: (K/2 -1)){
        C[K/2 + k] = C[K/2 + k - 1] + theta[k];
        C[K/2 - k] = -C[K/2 + k];
    }
    p_NS[1] = Phi((C[1] - (mu_s - tau))/sqrt(2.0));
    p_NS[K] = 1 - Phi((C[K - 1] - (mu_s - tau))/sqrt(2.0));

    for (k in 2:(K-1)) {
        p_NS[k] = Phi((C[k] - (mu_s - tau))/sqrt(2.0)) -
                   Phi((C[k - 1] - (mu_s - tau))/sqrt(2.0));
    }

    p_SN[1] = Phi((C[1] - (mu_s + tau))/sqrt(2.0));
    p_SN[K] = 1 - Phi((C[K - 1] - (mu_s + tau))/sqrt(2.0));
    
    for (k in 2:(K-1)) {
        p_SN[k] = Phi((C[k] - (mu_s + tau))/sqrt(2.0)) -
                   Phi((C[k - 1] - (mu_s + tau))/sqrt(2.0));
    }
}
model {
    for (k in 1:(K/2 - 1)) {
        theta[k] ~ half_normal(1000.0);
    }
    mu_s ~ normal(0.0, 100.0);
    tau ~ normal(0.0, 100.0);
    n_NS ~ multinomial(p_NS);
    n_SN ~ multinomial(p_SN);
}
