from cmdstanpy import CmdStanModel
import pandas as pd
import numpy as np
import scipy.stats as ss
import matplotlib.pyplot as plt
import seaborn as sb
 

outflnm = input('Output file (*.txt) = ')  
fout = open(outflnm, 'w')

inflnm = input('Input data file (*.xlsx) = ')
df_raw = pd.read_excel(inflnm)
print(df_raw)
data = np.array(df_raw.values)
print(data)
K = len(data)
print('K =', K)
n_n = data.T[1]
n_s = data.T[2]
s_n = data.T[3]
s_s = data.T[4]

print('n_n =', n_n)
print('n_s =', n_s)
print('s_n =', s_n)
print('s_s =', s_s)

model = CmdStanModel(stan_file = 'SDT_2AFC_KCat_odd.stan' if K % 2 == 1 else
                     'SDT_2AFC_KCat_even.stan')

Data = {'K':K, 'nn_cond':n_n, 'ns_cond':n_s, 'sn_cond':s_n, 'ss_cond':s_s}
fit = model.sample(data=Data)  

print(fit.summary())
fout.write(f'\n{fit.summary()}\n')

fit = fit.draws_pd()

mu_s_med = np.median(fit['mu_s'])
sb.kdeplot(fit['mu_s'])
plt.xlabel(r'$\mu_s$')
plt.title(r'$\mu_s$(Med) = {0:.3f}'.format(mu_s_med))
plt.show()

sgm_s_med = np.median(fit['sgm_s'])
sb.kdeplot(fit['sgm_s'])
plt.title(r'$\sigma_s$(Med) = {0:.3f}'.format(sgm_s_med))
plt.xlabel(r'$\sigma_s$')
plt.show()

C = []
for k in range(K-1):
    C.append(fit[f'C[{k+1}]'])
C = np.array(C).T

s_title = ''
if K % 2 == 1:
    for k in range(K-1):
        sb.kdeplot(C.T[k])  
        c_med = np.median(C.T[k])
        s_title += f'C{k+1}={c_med:.2f}'
        if k < K-2:
            s_title += ', '
    
else:
    for k in range(K-1):
        if k != (K//2) - 1:
            sb.kdeplot(C.T[k])  #fit['C'].T[k])
            c_med = np.median(C.T[k])
            s_title += f'C{k+1}={c_med:.2f}'
            if k < K-2:
                s_title += ', '
        else:
            plt.plot([0], [0], marker = 'o', markersize = 15, c = 'r')
            s_title += f'C{k+1}=0, '
            
plt.title('Med. estimates\n' + s_title)
plt.show()

b_med = np.median(fit['b'])
sb.kdeplot(fit['b'])
plt.title('b(Med) = {0:.3f}'.format(b_med))
plt.show()

cum_n_n = np.cumsum(n_n)
pcum_n_n = cum_n_n/cum_n_n[-1]
cum_n_s = np.cumsum(n_s)
pcum_n_s = cum_n_s / cum_n_s[-1]
cum_s_n = np.cumsum(s_n)
pcum_s_n = cum_s_n / cum_s_n[-1]
cum_s_s = np.cumsum(s_s)
pcum_s_s = cum_s_s / cum_s_s[-1]

fit_nn_cum_p = []
fit_ns_cum_p = []
fit_sn_cum_p = []
fit_ss_cum_p = []
for k in range(K+1):
    fit_nn_cum_p.append(fit[f'nn_cum_p[{k+1}]'])
    fit_ns_cum_p.append(fit[f'ns_cum_p[{k+1}]'])
    fit_sn_cum_p.append(fit[f'sn_cum_p[{k+1}]'])
    fit_ss_cum_p.append(fit[f'ss_cum_p[{k+1}]'])
fit_nn_cum_p = np.array(fit_nn_cum_p).T
fit_ns_cum_p = np.array(fit_ns_cum_p).T
fit_sn_cum_p = np.array(fit_sn_cum_p).T
fit_ss_cum_p = np.array(fit_ss_cum_p).T
                        
est_pcum_n_n = np.median(fit_nn_cum_p, axis = 0)[1:-1]
est_pcum_n_s = np.median(fit_ns_cum_p, axis = 0)[1:-1]
est_pcum_s_n = np.median(fit_sn_cum_p, axis = 0)[1:-1]
est_pcum_s_s = np.median(fit_ss_cum_p, axis = 0)[1:-1]

plt.plot(est_pcum_n_n, pcum_n_n[:-1], label = 'n_n')
plt.plot(est_pcum_n_s, pcum_n_s[:-1], label = 'n_s')
plt.plot(est_pcum_s_n, pcum_s_n[:-1], label = 's_n')
plt.plot(est_pcum_s_s, pcum_s_s[:-1], label = 's_s')
plt.plot([0,1], [0,1], c = 'k', ls = '--', label = 'Obs.=Est.')
plt.xlabel('Est.Cum.P')
plt.ylabel('Obs.Cum.P')
plt.legend()
plt.title('Cumulative Proportions')
plt.show()

fout.close()
print('\n', outflnm, 'was saved.\n')
