from cmdstanpy import CmdStanModel
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import csv
import seaborn as sb

flnm = input('入力データファイル名(*.csv) = ')
with open(flnm, 'r') as f:
    data = [v for v in csv.reader(f)]



fout_nm = input('出力テキストファイル名(*.txt) = ')
fout = open(fout_nm, 'w')
fout.write('Input Data File = {}\n'.format(flnm))
    
Freq_NS = []
Freq_NS.append(int(data[1][1]))
Freq_NS.append(int(data[1][2]))
Freq_SN = []
Freq_SN.append(int(data[2][1]))
Freq_SN.append(int(data[2][2]))
print(Freq_NS)
print(Freq_SN)
fout.write('<N, S>: {}'.format(Freq_NS))
fout.write('\n<S, N>: {}'.format(Freq_SN))
TN_NS = sum(Freq_NS)
Rating_NS = []
Rating_NS.append(Freq_NS[0])
Rating_NS.append(Freq_NS[1])

TN_SN = sum(Freq_SN)
Rating_SN = []
Rating_SN.append(TN_SN - Freq_SN[0])
Rating_SN.append(TN_SN - Freq_SN[1])

Data = {'n_NS': Rating_NS, 'n_SN': Rating_SN}

model = CmdStanModel(stan_file='SDT2AFC2Cat.stan')
fit = model.sample(data=Data)   

print(fit.summary())
fout.write(f'\n{fit.summary()}\n')


fit = fit.draws_pd()


mu = fit['mu_s']
tau = fit['tau']
p_NS = np.array([fit['p_NS[1]'], fit['p_NS[2]']]).T   
p_SN = np.array([fit['p_SN[1]'], fit['p_SN[2]']]).T

mu_L05 = np.percentile(mu, 5)
mu_med = np.percentile(mu, 50)
mu_U95 = np.percentile(mu, 95)
fout.write("\nd': \nMed. = {0:<.3f},  90%CI = [{1:<.3f}, {2:<.3f}".
           format(mu_med, mu_L05, mu_U95))

tau_L05 = np.percentile(tau, 5)
tau_med = np.percentile(tau, 50)
tau_U95 = np.percentile(tau, 95)
fout.write('\ntau: \nMed. = {0:<.3f},  90%CI ~ [{1:<.3f}, {2:<.3f}]'.
           format(tau_med, tau_L05, tau_U95))

p1 = np.median(p_NS, axis = 0)   #    [P(1|NS), P(2|NS)]
p2 = np.median(p_SN, axis = 0)
p2 = [p2[1], p2[0]]              #    [P(2|SN), P(1|SN)] 


sb.kdeplot(mu)
plt.xlabel(r"d'($\mu_S$)", fontsize = 14)
plt.title(r"Posterior Distribution of d'($\mu_S$)" + \
          '\nMed. = {0:<.3f},  90%CI = [{1:M<.3f}, {2:<.3f}]'.
          format(mu_med, mu_L05, mu_U95), fontsize = 16)
plt.show()


sb.kdeplot(tau)
plt.xlabel(r'$\tau$', fontsize = 18)
plt.title(r'Posterior Distribution of $\tau$' + \
          '\nMed. = {0:<.3f},  90%CI = [{1:<.3f}, {2:<.3f}]'.
          format(tau_med, tau_L05, tau_U95), fontsize = 16)
plt.show()

xcat = [1, 2]
xlabels = ['Cat-1', 'Cat-2']
y1 = [Freq_NS[0]/TN_NS, Freq_NS[1]/TN_NS]
y2 = [Freq_SN[0]/TN_SN, Freq_SN[1]/TN_SN]

plt.plot(xcat, y1, c='b', marker='s', markersize=20,
         linewidth = 0, label = 'Data/<N, S>')
plt.plot(xcat, p1, c='g', marker='o', markersize=30, fillstyle='none',
         linewidth = 0, markeredgewidth = 3, label = 'Model/<N, S>')
plt.plot(xcat, y2, c='r', marker='s', markersize=20,
         linewidth = 0, label = 'Data/<S, N>')
plt.plot(xcat, p2, c='m', marker='o', markersize=30, fillstyle='none',
         linewidth = 0, markeredgewidth=3, label = 'Model/<S, N>')
plt.xticks(xcat, xlabels, fontsize = 14)
plt.xlim(0.8, 2.2)
plt.xlabel('Rating Category', fontsize = 14)
plt.ylabel('Probability/Proportion', fontsize = 14)
plt.yticks(np.arange(0,1.1,0.2))
plt.title('Rating in Conditions <N, S> and <S, N>', fontsize = 18)
plt.legend(fontsize=18, loc='center')
plt.show()
      
fout.close()
print('\n' + fout_nm + ' was saved.\n')
