data {
    array[2] int n_NS;
    array[2] int n_SN;
}
parameters {
    real mu_s;
    real tau;
}
transformed parameters {
    simplex[2] p_NS;
    simplex[2] p_SN;
    p_NS[1] = Phi(-(mu_s - tau)/sqrt(2.0));
    p_NS[2] = 1 - p_NS[1];
    p_SN[1] = Phi(-(mu_s + tau)/sqrt(2.0));
    p_SN[2] = 1 - p_SN[1];
}
model {
    mu_s ~ normal(0.0, 100.0);
    tau ~ normal(0.0, 100.0);
    n_NS ~ multinomial(p_NS);
    n_SN ~ multinomial(p_SN);
}
