from cmdstanpy import CmdStanModel
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sb
import scipy.stats as ss
import arviz as az


inf_nm = input('Input data file(*.csv) = ') 
dframe = pd.read_csv(inf_nm)                #  データの読み込み

fout_nm = input('Output file(*.txt) = ')
fout = open(fout_nm, 'w')                   #　出力用ファイルの用意
fout.write('Input file = {inf_nm}\n')

df_keys = dframe.keys()
x_name = df_keys[1]
y_name = df_keys[2]
print(x_name, y_name)
x = dframe[x_name].values
x = x[np.isnan(x)==False]       #  空セルデータの削除
print('X =\n', x)
y = dframe[y_name].values
y = y[np.isnan(y)==False]       #  空セルデータの削除
print('Y =\n', y)

mean1 = np.mean(x)
sd1 = np.std(x)
print('mean1 =', mean1, '   sd1 =', sd1)
mean2 = np.mean(y)
sd2 = np.std(y)
print('mean2 =', mean2, '   sd2 =', sd2)

min1 = np.min(x)
max1 = np.max(x)
min2 = np.min(y)
max2 = np.max(y)
print(min1,'  ', max1)
print(min2,'  ', max2)

Data = {'n1':len(x), 'x':x, 'min1':min1, 'max1':max1,
        'n2':len(y), 'y':y, 'min2':min2, 'max2':max2}
#   コンパイル
model = CmdStanModel(stan_file="t_distri.stan")
#   サンプリング
fit = model.sample(data=Data)   

print(fit.summary())
fout.write('\n{}'.format(fit.summary()))

i_data = az.from_cmdstanpy(fit)           #   Arviz(az)用のデータに変換

az.plot_trace(i_data, var_names=['mu1','mu2','sgm1','sgm2','nu1','nu2'],
              figsize=(12,8))   
plt.tight_layout()
plt.show()

print(az.summary(i_data))   
fout.write('\nSummary:\n')
fout.write("{0}\n".format(az.summary(i_data,
                        var_names = ['mu1','mu2','sgm1','sgm2','nu1','nu2'])))

pd_fit_frame = fit.draws_pd()        #   Pandas DataFrameに変換

"""
      事後分布の中央値を点推定値とする
"""
mu1 = np.median(pd_fit_frame['mu1'])
sgm1 = np.median(pd_fit_frame['sgm1'])
nu1 = np.median(pd_fit_frame['nu1'])
mu2 = np.median(pd_fit_frame['mu2'])
sgm2 = np.median(pd_fit_frame['sgm2'])
nu2 = np.median(pd_fit_frame['nu2'])
"""
               パラメータmu1とmu2の事後分布
"""
plt.title('Posterior distributions' +f'\nmu1={mu1:.2f},  mu2={mu2:.2f}')
sb.kdeplot(pd_fit_frame['mu1'], label=x_name)
sb.kdeplot(pd_fit_frame['mu2'], label=y_name)
plt.xlabel('mu', fontsize=14)
plt.legend()
plt.show()
"""
           パラメータmu1とmu2の差の事後分布と事後確率
"""
diff_mu1_mu2 = pd_fit_frame['mu1'] - pd_fit_frame['mu2']
diff_mu_med = np.median(diff_mu1_mu2)
pos_idx = diff_mu1_mu2 > 0
neg_idx = diff_mu1_mu2 < 0
prop_pos = np.mean(pos_idx)     #   P(mu1-mu2>0)
prop_neg = np.mean(neg_idx)     #   P(mu1-mu2<0)
sb.kdeplot(diff_mu1_mu2)
plt.xlabel('mu1-mu2', fontsize=14)
plt.title(f'P(mu1>mu2)={prop_pos:.5f}, P(mu1<mu2)={prop_neg:.5f}')
plt.tight_layout()
plt.show()
"""
          パラメータsgm1とsgm2の事後分布
"""
plt.title('Posterior distributions'
          f'\nsgm1={sgm1:.1f},  sgm2={sgm2:.2f}')
sb.kdeplot(pd_fit_frame['sgm1'], label=x_name)
sb.kdeplot(pd_fit_frame['sgm2'], label=y_name)
plt.xlabel('sgm', fontsize=14)
plt.legend()
plt.show()
"""
         パラメータnu1とnu2の事後分布
"""
plt.title('Posterior distributions' +
          f'\nnu1={nu1:.2f},  nu2={nu2:.2f}')
plt.hist(pd_fit_frame['nu1'], color='g', alpha=0.5,
         density=True, label=x_name)
plt.hist(pd_fit_frame['nu2'], color='orange', alpha=0.5,
         density=True, label=y_name)
sb.kdeplot(pd_fit_frame['nu1'], color='g', label=x_name)
sb.kdeplot(pd_fit_frame['nu2'], color='orange', label=y_name)
plt.xlabel('nu', fontsize=14)
plt.legend()
plt.show()
"""
          データのヒストグラムとｔ分布のグラフ
"""
plt.hist(x, density=True, color='b', alpha=0.5, label=x_name)
plt.hist(y, density=True, color='orange', alpha=0.5, label=y_name)
"""
         グラフの横軸の範囲
"""
min_xy = min1 if min1 < min2 else min2
max_xy = max1 if max1 > max2 else max2
coord_xy = np.linspace(min_xy, max_xy, 1000)
density1 = ss.t.pdf(coord_xy, nu1, loc=mu1, scale=sgm1)   #  t分布
density2 = ss.t.pdf(coord_xy, nu2, loc=mu2, scale=sgm2)   #  t分布
plt.plot(coord_xy, density1, c='g', label=x_name)
plt.plot(coord_xy, density2, c='r', label=y_name)
plt.title(fr'{x_name}: $\mu$={mu1:.2f}, $\sigma$={sgm1:.2f}, $\nu$={nu1:.2f}' +
          '\n' +
          fr'{y_name}: $\mu$={mu2:.2f}, $\sigma$={sgm2:.2f}, $\nu$={nu2:.2f}',
          fontsize=14)
plt.legend()
plt.tight_layout()
plt.show()

fout.close()
print(fout_nm, 'was saved.')

