data {
    int n1;
    array[n1] real x;
    int n2;
    array[n2] real y;
    real min1;
    real max1;
    real min2;
    real max2;
}
parameters {
    real<lower=0, upper=1> vmu1;
    real<lower=0, upper=1> vsgm1;
    real<lower=0, upper=1> vmu2;
    real<lower=0, upper=1> vsgm2;
    real<lower=0, upper=1> vnu1;
    real<lower=0, upper=1> vnu2;
}
transformed parameters {
    real mu1;
    real<lower=0> sgm1;
    real mu2;
    real<lower=0> sgm2;
    real nu1;
    real nu2;
    /*
           Parameters rescaled
    */
    mu1 = min1 + (max1 - min1) * vmu1;
    sgm1 = 0.0001 + (max1 - min1) * vsgm1 / 2.0;
    mu2 = min2 + (max2 - min2) * vmu2;
    sgm2 = 0.0001 + (max2 - min2) * vsgm2 / 2.0;
    nu1 = 0.0001 + vnu1*100;
    nu2 = 0.0001 + vnu2*100;
}
model {
    vmu1 ~ beta(1, 1);
    vsgm1 ~ beta(1, 1);
    vmu2 ~ beta(1, 1);
    vsgm2 ~ beta(1, 1);
    vnu1 ~ beta(1, 1); 
    vnu2 ~ beta(1, 1); 
    x ~ student_t(nu1, mu1, sgm1);
    y ~ student_t(nu2, mu2, sgm2);
}
