import networkx as nx            
import matplotlib.pyplot as plt
import pandas as pd

df = pd.read_excel('Kanto_jp.xlsx')    #   Excelファイルの読み込み
nodes = df.values[:,0]                 #   ノード名のリスト
data = df.values[:,1:]                 #　 ノード間の隣接データ
n = len(data)                          #   ノード数

G = nx.Graph()                         #   無向グラフの準備
G.add_nodes_from(nodes)                #    ノードをすべて追加                     
for i in range(n-1):
    for j in range(i+1, n):
        if data[i][j] == 1:                 
            G.add_edge(nodes[i], nodes[j])   #    エッジの追加

pos = nx.spring_layout(G)                    #    配置の位置
nx.draw(G, pos, node_size=2000, with_labels = True, node_color='aqua',
        font_family='Microsoft JhengHei'  )  #   描画
plt.show()                                   #   表示  
