import networkx as nx  
import matplotlib.pyplot as plt

G = nx.DiGraph()

G.add_edge('Z', 'X')     #   エッジ　Z -> X
G.add_edge('Z', 'Y')     #   エッジ  Z -> Y
G.add_edge('X', 'Y')     #   エッジ　X -> Y
G.add_edge('Y', 'X')     #   エッジ　Y -> X

pos = nx.spring_layout(G)                            #  グラフの位置データ
nx.draw(G, pos, with_labels = True, font_size=30,    #  グラフの描画
        node_size=3000, node_color='orange',
        arrowstyle='-|>', arrowsize=50)            

nx.draw_networkx_edge_labels(G, pos,
                 edge_labels={('Z','X'):r'$\alpha$=0.7', #  Z -> X のラベル
                              ('Z','Y'):r'$\alpha$=0.6', #  Z -> Y のラベル
                              ('X','Y'):r'$r^{2}$=0.5'}, #  X -> Y のラベル
                 font_size=20)
plt.show()       #   グラフの表示
