import networkx as nx  
import matplotlib.pyplot as plt

cnvs = plt.figure()

G = nx.DiGraph()

G.add_edge('グー', 'チョキ')   #  グー　　＞　チョキ　のエッジ
G.add_edge('チョキ', 'パー')   #  チョキ　＞　パー　　のエッジ
G.add_edge('パー', 'グー')     #　パー　　＞　グー　　のエッジ

pos = nx.spring_layout(G)                            #  グラフの位置データ
nx.draw(G, pos, font_size=18,
        with_labels = True, node_size=3000, node_color='orange',
        edgecolors='k',
        arrowstyle='-|>', arrowsize=100,font_family='Microsoft JhengHei' )           #  グラフの描画

plt.show()        #   グラフの表示

